/*
 * Decompiled with CFR 0.152.
 */
package org.wipo.xsd2json.schema.builders.types;

import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import org.wipo.xsd2json.schema.builders.representation.BaseJsonElement;

public abstract class AbstractJsonSchemaBuilder {
    File xsdFile;
    Map<String, String> typeRefAnnex;
    String jsonSchemaExt;
    String versionTxt;
    boolean isMixedContent;
    boolean createDefsOnlyEntry;
    boolean choiceElem;
    int choiceCntr;
    boolean excludeInRequired;

    public Map<String, Object> createJsonSchema() {
        LinkedHashMap<String, Object> jsonSchemaMap = new LinkedHashMap<String, Object>();
        BaseJsonElement bje = this.addXsdElementToJsonSchema();
        jsonSchemaMap.putAll(this.createJsonSchemaFromJsonElement(bje));
        return jsonSchemaMap;
    }

    private Map<String, Object> createJsonSchemaFromJsonElement(BaseJsonElement bje) {
        LinkedHashMap<String, Object> jsonMap = new LinkedHashMap<String, Object>();
        if (this.createDefsOnlyEntry) {
            Map<String, Object> defs = bje.getDefinitions();
            String frstKey = null;
            Iterator<Map.Entry<String, Object>> iterator = defs.entrySet().iterator();
            if (iterator.hasNext()) {
                Map.Entry<String, Object> entr = iterator.next();
                frstKey = entr.getKey();
            }
            if (frstKey != null) {
                LinkedHashMap defsMap = (LinkedHashMap)defs.get(frstKey);
                LinkedHashMap<String, String> updDefsMap = new LinkedHashMap<String, String>();
                String descTxt = bje.getDescription();
                descTxt = descTxt != null ? String.valueOf(descTxt) + "; Version: ".concat(bje.getVersionText()) : "Version: ".concat(bje.getVersionText());
                updDefsMap.put("description", descTxt);
                updDefsMap.putAll(defsMap);
                defs.put(frstKey, updDefsMap);
            }
            jsonMap.put("$defs", defs);
        } else {
            jsonMap.put("properties", bje.getProperties());
            ArrayList<String> reqList = new ArrayList<String>();
            if (!bje.getRequiredList().isEmpty()) {
                reqList.add(bje.getLowerCamelCaseName());
                jsonMap.put("required", reqList);
            }
            jsonMap.put("$defs", bje.getDefinitions());
        }
        return jsonMap;
    }

    abstract BaseJsonElement addXsdElementToJsonSchema();
}

