/*
 * Decompiled with CFR 0.152.
 */
package org.wipo.xsd2json.schema.builders.representation;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.ws.commons.schema.XmlSchemaAnnotation;
import org.wipo.xsd2json.schema.builders.representation.BaseJsonElement;
import org.wipo.xsd2json.schema.builders.representation.SequenceJsonElement;
import org.wipo.xsd2json.utils.NamingUtils;

public class ChoiceJsonElement
extends BaseJsonElement {
    private List<BaseJsonElement> choiceList;
    private boolean mixedContent;
    private Map<String, String> typeRefAnnex;
    private String baseFilePath;
    private String jsonSchemaExt;
    private String versionTxt;

    public ChoiceJsonElement(String name, String schemaTypeName, boolean mixedContent, long minOccurs, long maxOccurs, long parentMaxOccurs, Map<String, String> typeRefAnnex, XmlSchemaAnnotation annotations, List<BaseJsonElement> choiceList, String baseFilePath, String choiceName, int multipleChoiceEntryCounter, boolean createDefsOnlyEntry, String jsonSchemaExt, String versionTxt) {
        super(name, schemaTypeName, true, minOccurs, maxOccurs, parentMaxOccurs, typeRefAnnex, annotations, null, null, createDefsOnlyEntry, multipleChoiceEntryCounter, true, baseFilePath, jsonSchemaExt, versionTxt);
        this.choiceList = choiceList;
        this.mixedContent = mixedContent;
        this.typeRefAnnex = typeRefAnnex;
        this.baseFilePath = baseFilePath;
        this.jsonSchemaExt = jsonSchemaExt;
        this.versionTxt = versionTxt;
        if (choiceName == null && choiceList != null) {
            for (BaseJsonElement elem : choiceList) {
                choiceName = String.valueOf(choiceName) + elem.getName() + "Or";
            }
        }
        if (this.name.endsWith("Or")) {
            this.name = this.name.substring(0, this.name.length() - 2);
        }
        this.name = NamingUtils.makeLowerCamelCase(choiceName.concat("Choice")).concat(multipleChoiceEntryCounter > 0 ? String.valueOf(multipleChoiceEntryCounter) : "");
        if (this.requiredList == null) {
            this.requiredList = new ArrayList();
        }
        if (this.requiredList.contains("name")) {
            this.requiredList.remove("name");
        }
    }

    @Override
    protected Map<String, Object> createDefinitionsMap() {
        LinkedHashMap<String, Object> defMap = new LinkedHashMap<String, Object>();
        if (this.choiceList != null) {
            LinkedHashMap<String, Object> choicesElemList = new LinkedHashMap<String, Object>();
            LinkedHashMap<String, Map<String, Object>> nonChoicesElemList = new LinkedHashMap<String, Map<String, Object>>();
            int nestedSeqCnt = 0;
            for (BaseJsonElement elem : this.choiceList) {
                BaseJsonElement dlrStrElm;
                if (elem instanceof SequenceJsonElement) {
                    ++nestedSeqCnt;
                    Map<String, Object> definitionsMap = elem.createDefinitionsMap();
                    if (elem.getLowerCamelCaseName().equals("sequence") && definitionsMap.containsKey("properties")) {
                        String seqWrapperName = this.getLowerCamelCaseName().concat("Sequence");
                        if (nestedSeqCnt > 1) {
                            seqWrapperName = String.valueOf(seqWrapperName) + String.valueOf(nestedSeqCnt);
                        }
                        nonChoicesElemList.put(seqWrapperName, definitionsMap);
                        continue;
                    }
                    nonChoicesElemList.put(elem.getLowerCamelCaseName(), elem.createDefinitionsMap());
                    continue;
                }
                if (elem instanceof ChoiceJsonElement) {
                    if (this.mixedContent && choicesElemList.isEmpty()) {
                        dlrStrElm = new BaseJsonElement("$", "$", 0L, 1L, this.parentMaxOccurs <= 1L ? 1L : this.parentMaxOccurs, this.typeRefAnnex, null, null, null, this.createDefsOnlyEntry, this.multipleChoicCntr, true, this.baseFilePath, this.jsonSchemaExt, this.versionTxt);
                        choicesElemList.put(dlrStrElm.getLowerCamelCaseName(), dlrStrElm.createDefinitionsMap());
                    }
                    choicesElemList.putAll(elem.createDefinitionsMap());
                    continue;
                }
                if (this.mixedContent && choicesElemList.isEmpty()) {
                    dlrStrElm = new BaseJsonElement("$", "$", 0L, 1L, this.parentMaxOccurs <= 1L ? 1L : this.parentMaxOccurs, this.typeRefAnnex, null, null, null, this.createDefsOnlyEntry, this.multipleChoicCntr, true, this.baseFilePath, this.jsonSchemaExt, this.versionTxt);
                    choicesElemList.put(dlrStrElm.getLowerCamelCaseName(), dlrStrElm.createDefinitionsMap());
                }
                choicesElemList.put(elem.getLowerCamelCaseName(), elem.createDefinitionsMap());
            }
            LinkedHashMap<String, Cloneable> choiceWrapMap = new LinkedHashMap<String, Cloneable>();
            if (!nonChoicesElemList.isEmpty()) {
                choicesElemList.putAll(nonChoicesElemList);
            }
            LinkedHashMap choiceElmPropsMap = new LinkedHashMap();
            ArrayList oneOfList = new ArrayList();
            for (Map.Entry choiceEntr : choicesElemList.entrySet()) {
                if (this.mixedContent || this.maxOccurs > 1L) {
                    ArrayList<Map> anyOfList = new ArrayList<Map>();
                    Map currEntrVal = (Map)choiceEntr.getValue();
                    LinkedHashMap<String, Object> itmsMap = new LinkedHashMap<String, Object>();
                    if (!currEntrVal.containsKey("items")) {
                        LinkedHashMap itmOnlyMap = new LinkedHashMap();
                        itmOnlyMap.putAll(currEntrVal);
                        anyOfList.add(itmOnlyMap);
                        itmsMap.put("type", "array");
                        itmsMap.put("items", currEntrVal);
                    } else {
                        Map currItms = (Map)currEntrVal.get("items");
                        anyOfList.add(currItms);
                        itmsMap.putAll(currEntrVal);
                    }
                    anyOfList.add(itmsMap);
                    LinkedHashMap anyOfMap = new LinkedHashMap();
                    if (((String)choiceEntr.getKey()).equals("$")) {
                        ArrayList<String> typeEntrs = new ArrayList<String>();
                        typeEntrs.add("string");
                        typeEntrs.add("array");
                        anyOfMap.put("type", typeEntrs);
                    }
                    anyOfMap.put("anyOf", anyOfList);
                    choiceElmPropsMap.put(((String)choiceEntr.getKey()).toString(), anyOfMap);
                } else {
                    choiceElmPropsMap.put(((String)choiceEntr.getKey()).toString(), choiceEntr.getValue());
                }
                LinkedHashMap oneOfReqMap = new LinkedHashMap();
                ArrayList<String> reqList = new ArrayList<String>();
                reqList.add(((String)choiceEntr.getKey()).toString());
                oneOfReqMap.put("required", reqList);
                oneOfList.add(oneOfReqMap);
            }
            if (this.minOccurs == 0L) {
                LinkedHashMap optAnyOfMap = new LinkedHashMap();
                ArrayList optAnyOfList = new ArrayList();
                optAnyOfList.addAll(oneOfList);
                optAnyOfMap.put("anyOf", optAnyOfList);
                LinkedHashMap optNotMap = new LinkedHashMap();
                optNotMap.put("not", optAnyOfMap);
                oneOfList.add(optNotMap);
            }
            choiceWrapMap.put("properties", choiceElmPropsMap);
            if (this.maxOccurs > 1L) {
                choiceWrapMap.put("anyOf", oneOfList);
            } else {
                choiceWrapMap.put("oneOf", oneOfList);
            }
            defMap.put(this.name, choiceWrapMap);
        }
        return defMap;
    }

    @Override
    protected Map<String, Object> getPropertiesMap() {
        LinkedHashMap<String, Object> choiceMap = new LinkedHashMap<String, Object>();
        if (this.choiceList != null) {
            LinkedHashMap<String, Object> choicesElemList = new LinkedHashMap<String, Object>();
            LinkedHashMap<String, Object> nonChoicesElemList = new LinkedHashMap<String, Object>();
            for (BaseJsonElement elem : this.choiceList) {
                if (elem instanceof SequenceJsonElement) {
                    nonChoicesElemList.putAll(elem.getPropertyForDefinition());
                    continue;
                }
                if (this.mixedContent && choicesElemList.isEmpty()) {
                    BaseJsonElement dlrStrElm = new BaseJsonElement("$", "$", 0L, 1L, 1L, this.typeRefAnnex, null, null, null, this.createDefsOnlyEntry, this.baseFilePath, this.jsonSchemaExt, this.versionTxt);
                    choicesElemList.putAll(dlrStrElm.getPropertyForDefinition());
                }
                choicesElemList.putAll(elem.getPropertyForDefinition());
            }
            LinkedHashMap<String, Object> choiceElmPropsMap = new LinkedHashMap<String, Object>();
            if (!this.mixedContent) {
                choiceElmPropsMap.put("properties", choicesElemList);
                ArrayList<LinkedHashMap<String, Object>> oneOfList = new ArrayList<LinkedHashMap<String, Object>>();
                oneOfList.add(choiceElmPropsMap);
                if (!nonChoicesElemList.isEmpty()) {
                    oneOfList.add(nonChoicesElemList);
                }
                LinkedHashMap<String, Object> oneOfMap = new LinkedHashMap<String, Object>();
                oneOfMap.put("oneOf", oneOfList);
                LinkedHashMap<String, Object> maxOccursMap = oneOfMap;
                if (this.maxOccurs > 1L) {
                    maxOccursMap = new LinkedHashMap();
                    maxOccursMap.put("type", "array");
                    maxOccursMap.put("minItems", this.minOccurs);
                    if (this.maxOccurs != Long.MAX_VALUE) {
                        maxOccursMap.put("maxItems", this.maxOccurs);
                    }
                    maxOccursMap.put("additionalItems", false);
                    ArrayList itemsList = new ArrayList();
                    LinkedHashMap<String, Object> oneItem = new LinkedHashMap<String, Object>();
                    oneItem.put("type", "object");
                    oneItem.putAll(oneOfMap);
                    itemsList.add(oneItem);
                    maxOccursMap.put("items", itemsList);
                }
                choiceMap.put(this.name, maxOccursMap);
            } else {
                choiceElmPropsMap.put("type", "object");
                choiceElmPropsMap.put("additionalProperties", false);
                if (!nonChoicesElemList.isEmpty()) {
                    choicesElemList.putAll(nonChoicesElemList);
                }
                choiceElmPropsMap.put("properties", choicesElemList);
                LinkedHashMap<String, Object> choiceElmPropsWrapperMap = new LinkedHashMap<String, Object>();
                choiceElmPropsWrapperMap.put("type", "array");
                choiceElmPropsWrapperMap.put("additionalItems", false);
                choiceElmPropsWrapperMap.put("items", choiceElmPropsMap);
                choiceMap.put(this.name, choiceElmPropsWrapperMap);
            }
        }
        return choiceMap;
    }
}

