/*
 * Decompiled with CFR 0.152.
 */
package org.wipo.xsd2json.utils;

import java.io.File;
import java.io.IOException;
import java.util.Map;
import org.apache.commons.io.FileUtils;
import org.wipo.xsd2json.main.InvokerMain;
import org.wipo.xsd2json.utils.NamingUtils;

public class OrganizationUtils {
    public static void moveFileToFolder(File fileEntry, File elementsFolder) throws IOException {
        FileUtils.copyFileToDirectory(fileEntry, elementsFolder);
    }

    public static void copyXsdsToRootFolder(File folderName) throws IOException {
        File rootFolder = OrganizationUtils.getAppRootFolder();
        File[] fileArray = folderName.listFiles();
        int n = fileArray.length;
        int n2 = 0;
        while (n2 < n) {
            File fileEntry = fileArray[n2];
            if (fileEntry.isDirectory()) {
                OrganizationUtils.copyXsdsToRootFolder(fileEntry);
            } else if (fileEntry.getName().contains("xsd")) {
                OrganizationUtils.moveFileToFolder(fileEntry, rootFolder);
            }
            ++n2;
        }
    }

    public static File getAppRootFolder() {
        return new File(InvokerMain.class.getProtectionDomain().getCodeSource().getLocation().getPath().replace("/target/classes", ""));
    }

    public static void clearXSDsFromRootFolder() throws IOException {
        File rootFolder = OrganizationUtils.getAppRootFolder();
        File[] fileArray = rootFolder.listFiles();
        int n = fileArray.length;
        int n2 = 0;
        while (n2 < n) {
            File fileEntry = fileArray[n2];
            if (fileEntry.getName().toLowerCase().contains("xsd")) {
                FileUtils.delete(fileEntry);
            }
            ++n2;
        }
    }

    public static String calculateCommonPathForAllXSDs(Map<String, String> allXsds) {
        String commonPathForAllXsds = "";
        for (String xsd : allXsds.keySet()) {
            commonPathForAllXsds = "".equals(commonPathForAllXsds) ? allXsds.get(xsd) : NamingUtils.findCommonSubstring(commonPathForAllXsds, allXsds.get(xsd));
        }
        return commonPathForAllXsds;
    }
}

