/*
 * Decompiled with CFR 0.152.
 */
package org.wipo.xsd2json.utils;

import java.util.ArrayList;
import java.util.List;

public class NamingUtils {
    public static List<String> KNOWN_TERMS = new ArrayList<String>();

    public static String getJsonFileNameFromXsdFileName(String xsd, String ext) {
        String parentFldr = "";
        String xsdFile = xsd;
        if (xsd.contains("\\")) {
            String[] tokens = xsd.split("\\\\");
            if (tokens.length > 2) {
                parentFldr = tokens[tokens.length - 2].equals("Document") ? tokens[tokens.length - 3].concat("\\").concat(tokens[tokens.length - 2]) : tokens[tokens.length - 2];
            }
            xsdFile = tokens[tokens.length - 1].replaceAll(".xsd", "");
        } else {
            xsdFile = xsd.replaceAll(".xsd", "");
        }
        return parentFldr.concat("\\").concat(NamingUtils.makeLowerCamelCase(xsdFile)).concat(ext);
    }

    public static String makeLowerCamelCase(String name) {
        if (name == null || name.trim().length() == 0) {
            return name;
        }
        if (Character.isLowerCase(name.charAt(0))) {
            return name;
        }
        String lccName = name;
        if (!Character.isLowerCase(name.charAt(0))) {
            if (!KNOWN_TERMS.isEmpty()) {
                for (String term : KNOWN_TERMS) {
                    if (!NamingUtils.isCamelCase(term) || !name.startsWith(term)) continue;
                    List<String> nameParts = NamingUtils.getNameParts(name);
                    lccName = "";
                    for (String part : nameParts) {
                        lccName = lccName == "" ? String.valueOf(lccName) + part.toLowerCase() : String.valueOf(lccName) + part;
                    }
                    return lccName;
                }
            }
            if (!KNOWN_TERMS.isEmpty()) {
                for (String term : KNOWN_TERMS) {
                    if (term.length() <= 1 || !name.startsWith(term)) continue;
                    for (String subTerm : KNOWN_TERMS) {
                        if (subTerm.length() <= 1 || !name.substring(term.length()).startsWith(subTerm)) continue;
                        lccName = term.toLowerCase().concat(name.substring(term.length()));
                        return lccName;
                    }
                }
            }
            List<String> nameParts = NamingUtils.getNameParts(name);
            if (!KNOWN_TERMS.isEmpty()) {
                for (String term : KNOWN_TERMS) {
                    String partOne = nameParts.get(0);
                    if (term.length() <= 3 && partOne.length() <= 3 && term.equalsIgnoreCase(partOne)) {
                        lccName = partOne.toLowerCase();
                        break;
                    }
                    if (term.length() <= 3 || partOne.length() <= 3 || !partOne.toLowerCase().startsWith(term.toLowerCase())) continue;
                    lccName = term.toLowerCase().concat(partOne.substring(term.length()));
                    break;
                }
            }
            if (lccName.equals(name)) {
                lccName = nameParts.get(0).toLowerCase();
            }
            int i = 1;
            while (i < nameParts.size()) {
                lccName = String.valueOf(lccName) + nameParts.get(i);
                ++i;
            }
        }
        return lccName;
    }

    private static boolean isCamelCase(String text) {
        boolean isCCTxt = false;
        if (text != null) {
            if (text.equals(text.toLowerCase()) || text.equals(text.toUpperCase())) {
                return isCCTxt;
            }
            int lastCTxtIndx = -1;
            int i = 0;
            while (i < text.length()) {
                if (Character.isUpperCase(text.charAt(i))) {
                    if (lastCTxtIndx == -1) {
                        ++lastCTxtIndx;
                    } else if (i > lastCTxtIndx + 1) {
                        isCCTxt = true;
                        break;
                    }
                }
                ++i;
            }
        }
        return isCCTxt;
    }

    private static List<String> getNameParts(String name) {
        ArrayList<String> parts = new ArrayList<String>();
        StringBuilder bfr = new StringBuilder();
        String versPart = null;
        char[] chars = name.toCharArray();
        if (name.toLowerCase().contains("_v")) {
            versPart = name.substring(name.toLowerCase().indexOf("_v"));
            chars = name.substring(0, name.toLowerCase().indexOf("_v")).toCharArray();
        }
        bfr.append(chars[0]);
        int i = 1;
        while (i < chars.length) {
            block6: {
                block5: {
                    block8: {
                        block7: {
                            block4: {
                                if (!Character.isLowerCase(chars[i])) break block4;
                                if ((!Character.isUpperCase(chars[i - 1]) || i + 1 >= chars.length || !Character.isUpperCase(chars[i + 1])) && (!Character.isLowerCase(chars[i - 1]) || i + 1 >= chars.length || !Character.isUpperCase(chars[i + 1]))) break block5;
                                bfr.append(chars[i]);
                                if (bfr.toString().trim().length() <= 0) break block5;
                                parts.add(bfr.toString());
                                bfr = new StringBuilder();
                                break block6;
                            }
                            if (!Character.isUpperCase(chars[i])) break block7;
                            if ((!Character.isLowerCase(chars[i - 1]) || i + 1 >= chars.length || !Character.isLowerCase(chars[i + 1])) && (!Character.isUpperCase(chars[i - 1]) || i + 1 >= chars.length || !Character.isLowerCase(chars[i + 1])) || bfr.toString().trim().length() <= 0) break block5;
                            parts.add(bfr.toString());
                            bfr = new StringBuilder();
                            bfr.append(chars[i]);
                            break block6;
                        }
                        if (!Character.isDigit(chars[i])) break block8;
                        if (i + 1 >= chars.length || !Character.isUpperCase(chars[i + 1]) || bfr.toString().trim().length() <= 0) break block5;
                        bfr.append(chars[i]);
                        parts.add(bfr.toString());
                        bfr = new StringBuilder();
                        break block6;
                    }
                    parts.clear();
                    parts.add(name);
                    bfr = null;
                    break;
                }
                bfr.append(chars[i]);
            }
            ++i;
        }
        if (bfr != null && bfr.toString().trim().length() > 0) {
            parts.add(bfr.toString());
            bfr = null;
        }
        if (versPart != null) {
            parts.add(versPart);
        }
        return parts;
    }

    public static String findCommonSubstring(String str1, String str2) {
        int m = str1.length();
        int n = str2.length();
        int[][] lcsTable = new int[m + 1][n + 1];
        int maxLength = 0;
        int maxRow = 0;
        int maxColumn = 0;
        int i = 0;
        while (i < m) {
            lcsTable[i][0] = 0;
            ++i;
        }
        int j = 0;
        while (j < n) {
            lcsTable[0][j] = 0;
            ++j;
        }
        i = 1;
        while (i <= m) {
            int j2 = 1;
            while (j2 <= n) {
                if (str1.charAt(i - 1) == str2.charAt(j2 - 1)) {
                    lcsTable[i][j2] = 1 + lcsTable[i - 1][j2 - 1];
                    if (maxLength < lcsTable[i][j2]) {
                        maxLength = lcsTable[i][j2];
                        maxRow = i;
                        maxColumn = j2;
                    }
                } else {
                    lcsTable[i][j2] = 0;
                }
                ++j2;
            }
            ++i;
        }
        return NamingUtils.fetchLCS(str1, maxLength, maxRow, maxColumn);
    }

    private static String fetchLCS(String x, int maxLength, int maxRow, int maxColumn) {
        StringBuilder longestCommonSubstring = new StringBuilder(maxLength);
        while (maxLength > 0) {
            longestCommonSubstring.append(x.charAt(maxRow - 1));
            --maxRow;
            --maxLength;
        }
        return longestCommonSubstring.reverse().toString();
    }
}

