/*
 * Decompiled with CFR 0.152.
 */
package org.wipo.xsd2json.schema.builders.types;

import java.io.File;
import java.util.List;
import java.util.Map;
import org.apache.ws.commons.schema.XmlSchemaEnumerationFacet;
import org.apache.ws.commons.schema.XmlSchemaFacet;
import org.apache.ws.commons.schema.XmlSchemaSimpleType;
import org.apache.ws.commons.schema.XmlSchemaSimpleTypeList;
import org.apache.ws.commons.schema.XmlSchemaSimpleTypeRestriction;
import org.apache.ws.commons.schema.XmlSchemaSimpleTypeUnion;
import org.wipo.xsd2json.schema.builders.elements.EnumElementBuilder;
import org.wipo.xsd2json.schema.builders.elements.SimpleRestrictionElementBuilder;
import org.wipo.xsd2json.schema.builders.elements.UnionElementBuilder;
import org.wipo.xsd2json.schema.builders.representation.BaseJsonElement;
import org.wipo.xsd2json.schema.builders.types.AbstractJsonSchemaBuilder;

public class SimpleTypeJsonSchemaBuilder
extends AbstractJsonSchemaBuilder {
    XmlSchemaSimpleType simpleType;
    long parentMaxOccurs;

    public SimpleTypeJsonSchemaBuilder(XmlSchemaSimpleType simpleType, long parentMaxOccurs, boolean createDefsOnlyEntry, File xsdFile, Map<String, String> typeRefAnnex, String jsonSchemaExt, String versionTxt) {
        this.simpleType = simpleType;
        this.parentMaxOccurs = parentMaxOccurs;
        this.xsdFile = xsdFile;
        this.createDefsOnlyEntry = createDefsOnlyEntry;
        this.typeRefAnnex = typeRefAnnex;
        this.jsonSchemaExt = jsonSchemaExt;
        this.versionTxt = versionTxt;
    }

    @Override
    BaseJsonElement addXsdElementToJsonSchema() {
        if (this.simpleType.getContent() instanceof XmlSchemaSimpleTypeRestriction) {
            boolean enumType = false;
            List<XmlSchemaFacet> facets = ((XmlSchemaSimpleTypeRestriction)this.simpleType.getContent()).getFacets();
            if (!facets.isEmpty()) {
                for (XmlSchemaFacet facet : facets) {
                    if (!(facet instanceof XmlSchemaEnumerationFacet)) continue;
                    enumType = true;
                    break;
                }
            }
            BaseJsonElement bje = null;
            if (enumType) {
                EnumElementBuilder eeb = new EnumElementBuilder(this.simpleType, this.parentMaxOccurs, null, this.createDefsOnlyEntry, this.typeRefAnnex, this.xsdFile, this.jsonSchemaExt, this.versionTxt);
                bje = eeb.build();
            } else {
                SimpleRestrictionElementBuilder sreb = new SimpleRestrictionElementBuilder(this.simpleType, this.parentMaxOccurs, null, this.createDefsOnlyEntry, this.typeRefAnnex, this.xsdFile, this.jsonSchemaExt, this.versionTxt);
                bje = sreb.build();
            }
            return bje;
        }
        if (this.simpleType.getContent() instanceof XmlSchemaSimpleTypeUnion) {
            UnionElementBuilder unionBuilder = new UnionElementBuilder(this.simpleType, this.createDefsOnlyEntry, this.typeRefAnnex, this.xsdFile, this.jsonSchemaExt, this.versionTxt);
            BaseJsonElement bje = unionBuilder.build();
            return bje;
        }
        if (this.simpleType.getContent() instanceof XmlSchemaSimpleTypeList) {
            throw new RuntimeException("Lists are not yet mapped!!!");
        }
        return null;
    }
}

