/*
 * Decompiled with CFR 0.152.
 */
package org.wipo.xsd2json.schema.builders.representation;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.ws.commons.schema.XmlSchemaAnnotation;
import org.wipo.xsd2json.schema.builders.representation.BaseJsonElement;

public class ComplexJsonElement
extends BaseJsonElement {
    private boolean extendOrRestrictType;
    private boolean isMixedContent;
    private List<BaseJsonElement> elementsList;
    private String jsonSchemaExt;
    private String versionTxt;

    public ComplexJsonElement(String name, String schemaTypeName, boolean extendOrRestrictType, long minOccurs, long maxOccurs, long parentMaxOccurs, boolean isMixedContent, Map<String, String> typeRefAnnex, XmlSchemaAnnotation annotations, List<BaseJsonElement> elementsList, String baseFilePath, boolean createDefsOnlyEntry, String jsonSchemaExt, String versionTxt) {
        super(name, schemaTypeName, minOccurs, maxOccurs, parentMaxOccurs, typeRefAnnex, annotations, null, null, createDefsOnlyEntry, -1, true, baseFilePath, jsonSchemaExt, versionTxt);
        this.isMixedContent = isMixedContent;
        this.type = new LinkedHashMap();
        if (isMixedContent) {
            this.type.put("type", "array");
        } else {
            this.type.put("type", "object");
        }
        this.extendOrRestrictType = extendOrRestrictType;
        this.elementsList = elementsList;
        this.jsonSchemaExt = jsonSchemaExt;
        this.versionTxt = versionTxt;
    }

    public List<BaseJsonElement> getElementsList() {
        return this.elementsList;
    }

    public void setElementsList(List<BaseJsonElement> elementsList) {
        this.elementsList = elementsList;
    }

    @Override
    protected Map<String, Object> createDefinitionsMap() {
        LinkedHashMap<String, Object> defMap = new LinkedHashMap<String, Object>();
        if (this.elementsList != null) {
            List<String> reqList;
            LinkedHashMap<String, Object> propertiesMap = new LinkedHashMap<String, Object>();
            for (BaseJsonElement elem : this.elementsList) {
                propertiesMap.putAll(elem.getDefinitions());
            }
            if (this.isMixedContent) {
                ArrayList<String> typeEntrs = new ArrayList<String>();
                typeEntrs.add("object");
                typeEntrs.add("array");
                defMap.put("type", typeEntrs);
            } else {
                defMap.put("type", "object");
            }
            defMap.put("additionalProperties", false);
            ArrayList oneOfEntrs = new ArrayList();
            ArrayList anyOfEntrs = new ArrayList();
            LinkedHashMap propertiesMapNew = new LinkedHashMap();
            for (Map.Entry entr : propertiesMap.entrySet()) {
                String compName = ((String)entr.getKey()).toString();
                if (compName.endsWith("Choice") || compName.contains("Choice") && this.multipleChoicCntr > 0 && compName.endsWith("Choice".concat(String.valueOf(this.multipleChoicCntr)))) {
                    LinkedHashMap compMapEntrs = (LinkedHashMap)entr.getValue();
                    LinkedHashMap mapEntrs = (LinkedHashMap)compMapEntrs.get("properties");
                    if (compMapEntrs.containsKey("oneOf")) {
                        oneOfEntrs.addAll((List)compMapEntrs.get("oneOf"));
                    }
                    if (compMapEntrs.containsKey("anyOf")) {
                        anyOfEntrs.addAll((List)compMapEntrs.get("anyOf"));
                    }
                    propertiesMapNew.putAll(mapEntrs);
                    continue;
                }
                propertiesMapNew.put(compName, entr.getValue());
            }
            defMap.put("properties", propertiesMapNew);
            if (!oneOfEntrs.isEmpty()) {
                defMap.put("oneOf", oneOfEntrs);
            }
            if (!anyOfEntrs.isEmpty()) {
                defMap.put("anyOf", anyOfEntrs);
            }
            if ((reqList = this.getAllRequiredList()) != null && !reqList.isEmpty()) {
                defMap.put("required", reqList);
            }
        }
        return defMap;
    }

    @Override
    protected Map<String, Object> getPropertiesMap() {
        LinkedHashMap<String, Object> propertiesMap = new LinkedHashMap<String, Object>();
        for (BaseJsonElement elem : this.elementsList) {
            if (elem instanceof ComplexJsonElement) {
                if (elem.getRef() != null) {
                    LinkedHashMap<String, String> refMap = new LinkedHashMap<String, String>();
                    refMap.put("$ref", elem.getRef());
                    propertiesMap.put(elem.getLowerCamelCaseName(), refMap);
                    continue;
                }
                propertiesMap.put(elem.getLowerCamelCaseName(), elem.getType());
                continue;
            }
            propertiesMap.putAll(elem.getPropertiesMap());
        }
        return propertiesMap;
    }

    @Override
    public List<String> getAllRequiredList() {
        ArrayList<String> allRequiredList = new ArrayList<String>();
        for (BaseJsonElement elem : this.elementsList) {
            List<String> elemReqList = elem.getAllRequiredList();
            if (elemReqList == null) continue;
            for (String elemReq : elemReqList) {
                if (allRequiredList.contains(elemReq)) continue;
                allRequiredList.add(elemReq);
            }
        }
        return allRequiredList;
    }
}

