/*
 * Decompiled with CFR 0.152.
 */
package org.wipo.xsd2json.converter;

import java.io.File;
import java.io.IOException;
import java.net.URISyntaxException;
import java.util.Map;
import org.wipo.xsd2json.converter.JsonSchemaBuilder;
import org.wipo.xsd2json.utils.annex.SchemaAnnexUtils;

public class JsonSchemaBuilderFactory {
    private File sourceXsdFile;
    private Map<String, String> typeRefAnnex;
    private String jsonSchemaExt;

    public JsonSchemaBuilderFactory(File sourceXsdFile, String jsonSchemaExt) throws IOException, URISyntaxException {
        this.sourceXsdFile = sourceXsdFile;
        this.jsonSchemaExt = jsonSchemaExt;
        SchemaAnnexUtils annexUtils = new SchemaAnnexUtils(this.sourceXsdFile);
        this.typeRefAnnex = annexUtils.getSchemaLocationsMap();
    }

    private JsonSchemaBuilder create(File xsd) {
        return new JsonSchemaBuilder(xsd, this.typeRefAnnex, this.jsonSchemaExt);
    }

    public File getSourceXsdFile() {
        return this.sourceXsdFile;
    }

    public Map<String, Object> createJsonSchema() throws IOException {
        JsonSchemaBuilder schemaBuilder = this.create(this.sourceXsdFile);
        Map<String, Object> finalMap = schemaBuilder.createJsonSchema();
        return finalMap;
    }

    public Map<String, String> getTypeRefAnnex() {
        return this.typeRefAnnex;
    }
}

