<?xml version="1.0" encoding="utf-8"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">
<xsl:variable name="lowercase">abcdefghijklmnopqrstuvwxyz</xsl:variable>
<xsl:variable name="uppercase">ABCDEFGHIJKLMNOPQRSTUVWXYZ</xsl:variable>
	<xsl:output encoding="unicode" method="text"/>

	<xsl:template match="/lang"><xsl:text>&lt;?xml version="1.0" encoding="unicode"?&gt;
&lt;translations&gt;</xsl:text>
	<xsl:apply-templates select="text"/>
&lt;/translations&gt;
	</xsl:template>

<xsl:template match="text">
	<xsl:text>&lt;entry id="</xsl:text><xsl:value-of select="@id"/><xsl:text>"
	     </xsl:text>
	<xsl:variable name="lang"><xsl:value-of select="@lang"/></xsl:variable>
	<xsl:value-of select="translate($lang,$uppercase,$lowercase)"/>
	<xsl:text>=</xsl:text>
	<xsl:choose>
		<xsl:when test="contains(text(),'&quot;')">'<xsl:value-of select="text()"/>'</xsl:when>
		<xsl:otherwise>"<xsl:value-of select="text()"/>"</xsl:otherwise>
	</xsl:choose>
	<xsl:text>
	/&gt;</xsl:text>
	<xsl:if test="position()!=last()"></xsl:if><xsl:text>
	</xsl:text>
</xsl:template>

</xsl:stylesheet>
<!-- Stylus Studio meta-information - (c)1998-2004. Sonic Software Corporation. All rights reserved.
<metaInformation>
<scenarios ><scenario default="yes" name="Scenario1" userelativepaths="yes" externalpreview="no" url="lang_offline_EN_FR_ES_DE_RU.xml" htmlbaseurl="" outputurl="" processortype="internal" profilemode="0" profiledepth="" profilelength="" urlprofilexml="" commandline="" additionalpath="" additionalclasspath="" postprocessortype="none" postprocesscommandline="" postprocessadditionalpath="" postprocessgeneratedext=""/></scenarios><MapperMetaTag><MapperInfo srcSchemaPathIsRelative="yes" srcSchemaInterpretAsXML="no" destSchemaPath="" destSchemaRoot="" destSchemaPathIsRelative="yes" destSchemaInterpretAsXML="no"/><MapperBlockPosition></MapperBlockPosition></MapperMetaTag>
</metaInformation>
-->