<?xml version="1.0"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:w="http://schemas.microsoft.com/office/word/2003/wordml" xmlns:v="urn:schemas-microsoft-com:vml" xmlns:w10="urn:schemas-microsoft-com:office:word"
                xmlns:sl="http://schemas.microsoft.com/schemaLibrary/2003/core" xmlns:aml="http://schemas.microsoft.com/aml/2001/core" xmlns:wx="http://schemas.microsoft.com/office/word/2003/auxHint" xmlns:o="urn:schemas-microsoft-com:office:office"
                xmlns:dt="uuid:C2F41010-65B3-11d1-A29F-00AA00C14882" xmlns:msxsl="urn:schemas-microsoft-com:xslt" xmlns:var="var">

	<xsl:output method="html" indent="no" encoding="utf-8"/>
	<xsl:include href="simple-wxml-header.xsl"/>
	
	<xsl:param name="dotfile"/>
	
	<xsl:variable name="advfooter" select="1"/>
 	<xsl:variable name="fulledition" select="substring-after(//ipcEntries/@displayMode, 'e')"/>
	<xsl:variable name="year" select="substring($fulledition, 1, 4)"/>
	<xsl:variable name="edition">
		<xsl:choose>
			<xsl:when test="$fulledition='20090101'">2009.01</xsl:when>
			<xsl:when test="$fulledition='20060101'">2006.01</xsl:when>
			<xsl:when test="$fulledition='20000101'">7</xsl:when>
			<xsl:when test="$fulledition='19950101'">6</xsl:when>
			<xsl:when test="$fulledition='19900101'">5</xsl:when>
			<xsl:when test="$fulledition='19850101'">4</xsl:when>
			<xsl:when test="$fulledition='19800101'">3</xsl:when>
			<xsl:when test="$fulledition='19740701'">2</xsl:when>
			<xsl:when test="$fulledition='19680901'">1</xsl:when>
			<xsl:when test="string-length($fulledition)=8">
				<xsl:value-of select="concat(substring($fulledition,1,4),'.',substring($fulledition,5,2))"/>
			</xsl:when>
			<xsl:otherwise><xsl:value-of select="$fulledition"/></xsl:otherwise>
		</xsl:choose>
	</xsl:variable>	
<!--	<xsl:variable name="edition" select="8"/>
	<xsl:variable name="year" select="2006"/>
-->	<xsl:variable name="section" select="//ipcEntry[@kind='s']/@symbol"/>
	<xsl:variable name="volume" select="translate($section, 'ABCDEFGH', '11223344')"/>
<!--	<xsl:variable name="lc" select="'abcdefghijklmnopqrstuvwxyz'"/>
	<xsl:variable name="uc" select="'ABCDEFGHIJKLMNOPQRSTUVWXYZ'"/>-->

	<!-- 20150915 TA -->
	<xsl:variable name="lang">
		<xsl:choose>
		<xsl:when test="/ipcEntries/@lang"><xsl:value-of select="ipcEntries/@lang"/></xsl:when>
	 	<xsl:otherwise>
	 		<xsl:value-of select="//ipcEntry[@kind='s']/@lang"/>
	 	</xsl:otherwise>
	 	</xsl:choose>
	</xsl:variable>
	<!-- 20150915 TA -->
	<xsl:variable name="LANG" select="translate($lang,'abcdefghijklmnopqrstuvwxyz','ABCDEFGHIJKLMNOPQRSTUVWXYZ')"/>

	<xsl:variable name="level" select="/ipcEntries/@level"/>
	
	<xsl:variable name="fixedTextFile" select="concat($LANG,'_ipc_fixed_texts.xml')"/>

	<xsl:include href="lang.xsl"/>
	<xsl:output indent="yes"/>

	<xsl:template match="/">
		<xsl:text disable-output-escaping="yes">&lt;?</xsl:text>mso-application progid="Word.Document"<xsl:text disable-output-escaping="yes">?&gt;</xsl:text>
		<w:wordDocument 
			xmlns:w="http://schemas.microsoft.com/office/word/2003/wordml" 
			xmlns:v="urn:schemas-microsoft-com:vml" 
			xmlns:w10="urn:schemas-microsoft-com:office:word" 
			xmlns:sl="http://schemas.microsoft.com/schemaLibrary/2003/core" 
			xmlns:aml="http://schemas.microsoft.com/aml/2001/core" 
			xmlns:wx="http://schemas.microsoft.com/office/word/2003/auxHint" 
			xmlns:o="urn:schemas-microsoft-com:office:office" 
			xmlns:dt="uuid:C2F41010-65B3-11d1-A29F-00AA00C14882" 
			w:macrosPresent="no" 
			w:embeddedObjPresent="no" 
			w:ocxPresent="no" 
			xml:space="preserve">
	        <o:DocumentProperties>
	            <o:Title></o:Title>
	            <o:Subject>Int.Cl.</o:Subject> 
	            <o:Author>WIPO</o:Author>
	            <!-- <o:Keywords>th edition, <xsl:value-of select="$year"/></o:Keywords> -->
				<o:Keywords><!-- TA 20071127 --><xsl:choose><xsl:when test="$level='c'"><xsl:call-template name="translate"><xsl:with-param name="id" select="'edition'"/></xsl:call-template><xsl:value-of select="$year"/></xsl:when>
						<xsl:otherwise><xsl:value-of select="$edition"/></xsl:otherwise>
					</xsl:choose></o:Keywords>

				<!--Vol. <xsl:value-of select="$volume"/>, Section <xsl:value-of select="$section"/>-->
	        	<!--
	            <o:Description>
	            	<xsl:variable name="replace0"><xsl:call-template name="translate"><xsl:with-param name="id" select="'vol'"/></xsl:call-template></xsl:variable><xsl:variable name="replace1"><xsl:choose>
								<xsl:when test="contains($replace0, '%v')"><xsl:value-of select="concat(substring-before($replace0, '%v'), $volume, substring-after($replace0, '%v'))"/></xsl:when>
								<xsl:otherwise><xsl:value-of select="$replace0"/></xsl:otherwise>
							</xsl:choose></xsl:variable><xsl:variable name="replace2"><xsl:choose>
								<xsl:when test="contains($replace1, '%s')"><xsl:value-of select="concat(substring-before($replace1, '%s'), $section, substring-after($replace1, '%s'))"/></xsl:when>
								<xsl:otherwise><xsl:value-of select="$replace1"/></xsl:otherwise>
							</xsl:choose></xsl:variable><xsl:value-of select="$replace2"/></o:Description>
				-->
	        	<o:Description><xsl:choose>
					<xsl:when test="$level='c'">
						<xsl:variable name="replace0">
							<xsl:call-template name="translate"><xsl:with-param name="id" select="'vol'"/></xsl:call-template>
						</xsl:variable>
						<xsl:variable name="replace1">
							<xsl:choose>
								<xsl:when test="contains($replace0, '%v')">
									<xsl:value-of select="concat(substring-before($replace0, '%v'), $volume, substring-after($replace0, '%v'))"/>
								</xsl:when>
								<xsl:otherwise>
									<xsl:value-of select="$replace0"/>
								</xsl:otherwise>
							</xsl:choose>
						</xsl:variable>
						<xsl:variable name="replace2">
							<xsl:choose>
								<xsl:when test="contains($replace1, '%s')">
									<xsl:value-of select="concat(substring-before($replace1, '%s'), $section, substring-after($replace1, '%s'))"/>
								</xsl:when>
								<xsl:otherwise>
									<xsl:value-of select="$replace1"/>
								</xsl:otherwise>
							</xsl:choose>
						</xsl:variable>
						<xsl:value-of select="$replace2"/>
					</xsl:when>
					<xsl:otherwise>, <xsl:call-template name="translate"><xsl:with-param name="id" select="'section'"/></xsl:call-template><xsl:text> </xsl:text><xsl:value-of select="$section"/></xsl:otherwise>
				</xsl:choose></o:Description>

	            <o:Revision>2</o:Revision>
	            <o:TotalTime>0</o:TotalTime>
	            <o:Created>2005-04-12T18:26:00Z</o:Created>
	            <o:Company>Arcanum Development</o:Company>
				<o:Comments><xsl:call-template name="translate"><xsl:with-param name="id" select="'section'"/></xsl:call-template><xsl:text> </xsl:text><xsl:value-of select="$section"/></o:Comments>
	        </o:DocumentProperties>
			
			<xsl:call-template name="DocumentProperties">
				<xsl:with-param name="dotfile" select="$dotfile"/>
			</xsl:call-template>
			
			<w:body>
				<!-- <xsl:call-template name="headerFooter"> 
								<xsl:with-param name="first" select="'1'"/>
				<xsl:with-param name="edition" select="$fulledition"/>
				<xsl:with-param name="year" select="$year"/>
				<xsl:with-param name="section" select="$section"/>
				<xsl:with-param name="volume" select="$volume"/>
				<xsl:with-param name="advfooter" select="$advfooter"/>
				<xsl:with-param name="level" select="/ipcEntries/@level"/>

				</xsl:call-template>
				-->
				<xsl:apply-templates select="ipcEntries/ipcEntry"/>
			</w:body>
		</w:wordDocument>
	</xsl:template>

	<xsl:template match="ipcEntry[@kind='s']">
        <wx:sect>
			<xsl:call-template name="bookMark"/>
	        <w:p>
	            <w:pPr>
	                <w:pStyle w:val="section"/>
	            </w:pPr>
				<w:r>
					<w:t><xsl:variable name="sectionCaption"><xsl:call-template name="translate"><xsl:with-param name="id" select="'section'"/></xsl:call-template></xsl:variable><xsl:if test="not(contains(normalize-space(textBody),$sectionCaption))"><xsl:value-of select="concat($sectionCaption,' ',@symbol,' ','&#8212;',' ')"/></xsl:if>
					<xsl:apply-templates select="textBody/title/titlePart"/>
					</w:t>
				</w:r>
	        </w:p>
			<w:p>
	            <w:pPr>
	                <w:pStyle w:val="toctitle"/>
	                <w:spacing w:after="567"/>
	                <w:rPr>
	                    <w:b w:val="off"/>
	                </w:rPr>
	            </w:pPr>
	            <w:r>
	                <w:t><xsl:call-template name="translate"><xsl:with-param name="id" select="'contents_of_section'"/></xsl:call-template></w:t>
	            </w:r>
	            <w:r>
	                <w:rPr>
	                    <w:b w:val="off"/>
	                </w:rPr>
	                <w:br/>
	                <w:t><xsl:call-template name="translate"><xsl:with-param name="id" select="'references_and_notes_omitted'"/></xsl:call-template></w:t>
	            </w:r>
	        </w:p>
			<xsl:call-template name="headerFooter">
				<xsl:with-param name="edition"><xsl:value-of select="$edition"/></xsl:with-param>
				<xsl:with-param name="year"><xsl:value-of select="$year"/></xsl:with-param>
				<xsl:with-param name="volume"><xsl:value-of select="$volume"/></xsl:with-param>
				<xsl:with-param name="section"><xsl:value-of select="$section"/></xsl:with-param>
			</xsl:call-template>
            <aml:annotation aml:id="1" w:type="Word.Bookmark.Start" w:name="sectNoteBegin"/>
            <aml:annotation aml:id="1" w:type="Word.Bookmark.End"/>
        </wx:sect>
		<wx:sect>
			<xsl:apply-templates select="ipcEntry"/>
		</wx:sect>
        <wx:sect>
            <w:p>
                <w:pPr>
                    <w:pStyle w:val="tocsubclass"/>
                    <w:sectPr>
                        <w:type w:val="continuous"/>
                        <w:pgSz w:w="11907" w:h="16840" w:code="9"/>
                        <w:pgMar w:top="1020" w:right="425" w:bottom="1020" w:left="425" w:header="510" w:footer="454" w:gutter="652"/>
                        <w:cols w:space="720"/>
                    </w:sectPr>
                </w:pPr>
            </w:p>
        </wx:sect>
        <wx:sect>
            <w:p>
                <w:pPr>
                    <w:pStyle w:val="tocsubclass"/>
                </w:pPr>
            </w:p>
            <w:sectPr>
                <w:type w:val="continuous"/>
                <w:pgSz w:w="11907" w:h="16840" w:code="9"/>
                <w:pgMar w:top="1020" w:right="425" w:bottom="1020" w:left="425" w:header="510" w:footer="454" w:gutter="652"/>
                <w:cols w:space="720"/>
            </w:sectPr>
        </wx:sect>
	</xsl:template>

	<xsl:template match="ipcEntry[@kind='t']">
		<xsl:call-template name="bookMark"/>
		<w:p>
		    <w:pPr>
		        <w:pStyle w:val="tocsubtitle"/>
		        <w:spacing w:before="0" w:after="624"/>
				<xsl:call-template name="addColumn"/>
		    </w:pPr>
		    <w:r>
				<w:t><xsl:call-template name="translate"><xsl:with-param name="id" select="'subsection'"/></xsl:call-template></w:t>
		    </w:r>
		    <w:r>
		        <w:rPr>
		            <w:b w:val="off"/>
		        </w:rPr>
		        <w:tab wx:wTab="240" wx:tlc="none" wx:cTlc="4"/>
		    </w:r>
		    <w:r>
		        <w:rPr>
		            <w:u w:val="single"/>
		        </w:rPr>
		        <xsl:apply-templates select="textBody"/>
		    </w:r>
		</w:p>
	</xsl:template>

	<xsl:template match="ipcEntry[@kind='c']">
		<xsl:call-template name="bookMark"/>
		<w:p>
            <w:pPr>
                <w:pStyle w:val="tocclass"/>
                <w:spacing w:before="0"/>
				<xsl:call-template name="addColumn"/>
                <w:rPr>
                    <w:b w:val="off"/>
                </w:rPr>
            </w:pPr>
            <w:r>
                <w:t><xsl:call-template name="translateref"><xsl:with-param name="ref" select="@symbol"/></xsl:call-template></w:t>
            </w:r>
            <w:r>
                <w:rPr>
                    <w:b w:val="off"/>
                </w:rPr>
                <w:tab wx:wTab="330" wx:tlc="none" wx:cTlc="6"/>
            </w:r>
            <w:r>
                <xsl:apply-templates select="textBody"/>
            </w:r>
            <w:r>
                <w:rPr>
                    <w:b w:val="off"/>
                </w:rPr>
                <w:tab wx:wTab="585" wx:tlc="none" wx:cTlc="12"/>
            </w:r>
            <w:fldSimple w:instr=" DOCPROPERTY {@symbol} \* MERGEFORMAT ">
                <w:r>
                    <w:rPr>
                        <w:b w:val="off"/>
                    </w:rPr>
                    <w:t></w:t>
                </w:r>
            </w:fldSimple>
        </w:p>
	</xsl:template>

	<xsl:template match="ipcEntry[@kind='u']">
		<xsl:call-template name="bookMark"/>
		<w:p>
            <w:pPr>
                <w:pStyle w:val="tocsubclass"/>
				<xsl:call-template name="addColumn"/>
				<xsl:if test="following-sibling::ipcEntry[1]/@kind != 'u'">
                	<w:spacing w:after="567"/>
				</xsl:if>
            </w:pPr>
            <w:r>
                <w:t><xsl:call-template name="translateref"><xsl:with-param name="ref" select="@symbol"/></xsl:call-template></w:t>
            </w:r>
            <w:r>
                <w:tab wx:wTab="150" wx:tlc="none" wx:cTlc="2"/>
                <xsl:apply-templates select="textBody"/>
            </w:r>
            <w:r>
                <w:tab/>
            </w:r>
            <w:fldSimple w:instr=" DOCPROPERTY {@symbol} \* MERGEFORMAT ">
                <w:r>
                    <w:t></w:t>
                </w:r>
            </w:fldSimple>
        </w:p>
	</xsl:template>

	<xsl:template name="addColumn">
		<xsl:if test="not(following-sibling::ipcEntry)">
	        <w:sectPr>
	            <w:type w:val="continuous"/>
	            <w:pgSz w:w="11907" w:h="16840" w:code="9"/>
	            <w:pgMar w:top="1020" w:right="425" w:bottom="1020" w:left="425" w:header="510" w:footer="454" w:gutter="652"/>
	            <w:cols w:num="2" w:space="567"/>
	        </w:sectPr>
		</xsl:if>
	</xsl:template>

	<xsl:template match="ipcEntry">
<!--		<w:p>
			<w:r>
				<w:t><xsl:text>Unknown ipcEntry, kind='</xsl:text><xsl:value-of select="@kind"/><xsl:text>'</xsl:text></w:t>
			</w:r>
		</w:p>-->
	</xsl:template>

	<xsl:template match="textBody">
		<xsl:apply-templates select="title"/>
	</xsl:template>

	<xsl:template match="title">
		<w:t>
			<xsl:apply-templates select="titlePart"/>
		</w:t>
	</xsl:template>

	<xsl:template match="titlePart">
		<xsl:if test="position() != 1"><xsl:text>; </xsl:text></xsl:if>
		<xsl:apply-templates select="text"/>
	</xsl:template>

	<xsl:template match="text">
		<xsl:apply-templates/>
	</xsl:template>

	<xsl:template match="emdash">
		<xsl:text disable-output-escaping="yes">&lt;/w:t&gt;&lt;/w:r&gt;</xsl:text>
		<w:r>
            <w:rPr>
                <w:spacing w:val="-40"/>
                <w:position w:val="2"/>
            </w:rPr>
            <w:noBreakHyphen/>
        </w:r>
        <w:r>
            <w:rPr>
                <w:spacing w:val="-40"/>
                <w:position w:val="2"/>
            </w:rPr>
            <w:noBreakHyphen/>
        </w:r>
        <w:r>
            <w:rPr>
                <w:spacing w:val="-40"/>
                <w:position w:val="2"/>
            </w:rPr>
            <w:noBreakHyphen/>
        </w:r>
		<xsl:text disable-output-escaping="yes">&lt;w:r&gt;&lt;w:t&gt;</xsl:text>
	</xsl:template>

	<xsl:template name="bookMark">
        <aml:annotation aml:id="2" w:type="Word.Bookmark.Start" w:name="toc{@symbol}"/>
        <aml:annotation aml:id="2" w:type="Word.Bookmark.End"/>		
	</xsl:template>

	<xsl:template match="sref">
		<xsl:text> </xsl:text>
		<xsl:call-template name="translateref">
			<xsl:with-param name="ref" select="@ref"/>
		</xsl:call-template>
		<xsl:text> </xsl:text>
	</xsl:template>

	<xsl:template match="mref">
		<xsl:text> </xsl:text>
		<xsl:call-template name="translateref">
			<xsl:with-param name="ref" select="@ref"/>
		</xsl:call-template>
		<xsl:text> to </xsl:text>
		<xsl:call-template name="translateref">
			<xsl:with-param name="ref" select="@endRef"/>
		</xsl:call-template>
		<xsl:text> </xsl:text>
	</xsl:template>

	<xsl:template name="translateref">
		<xsl:param name="ref"/>
		<xsl:variable name="len" select="string-length($ref)"/>
		<xsl:variable name="ipcEntry" select="ancestor-or-self::ipcEntry"/>
		<xsl:choose>
			<xsl:when test="$ipcEntry/@kind='i'">
				<xsl:call-template name="renderSymbolNum">
					<xsl:with-param name="data"><xsl:value-of select="substring($ref,5)"/></xsl:with-param>
				</xsl:call-template>
			</xsl:when>
			<xsl:otherwise>
				<xsl:choose>
					<xsl:when test="$len=3">
						<xsl:value-of select="substring($ref,1,1)"/>
						<xsl:value-of select="substring($ref,2,2)"/>
					</xsl:when>
					<xsl:when test="$len=4">
						<xsl:value-of select="substring($ref,1,1)"/>
						<xsl:value-of select="substring($ref,2,2)"/>
						<xsl:value-of select="substring($ref,4,1)"/>
					</xsl:when>
					<xsl:when test="$len &gt; 8">
						<xsl:value-of select="substring($ref,1,1)"/>
						<xsl:value-of select="substring($ref,2,2)"/>
						<xsl:value-of select="substring($ref,4,1)"/>
						<xsl:call-template name="renderSymbolNum">
							<xsl:with-param name="data"><xsl:value-of select="substring($ref,5)"/></xsl:with-param>
						</xsl:call-template>
					</xsl:when>
					<xsl:otherwise>
						<xsl:value-of select="$ref"/>
					</xsl:otherwise>
				</xsl:choose>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>

	<xsl:template name="renderSymbolNum">
		<xsl:param name="data"/>
		<xsl:choose>
			<xsl:when test="substring($data,1,2)='00'">
				<xsl:value-of select="substring($data,3,1)"/>
			</xsl:when>
			<xsl:when test="substring($data,1,1)='0'">
				<xsl:value-of select="substring($data,2,2)"/>
			</xsl:when>
			<xsl:otherwise>
				<xsl:value-of select="substring($data,1,3)"/>
			</xsl:otherwise>
		</xsl:choose>
		<xsl:text>/</xsl:text>
		<xsl:value-of select="substring($data,4)"/>
	</xsl:template>

	<xsl:template name="nbsp"><xsl:text> </xsl:text></xsl:template>

</xsl:stylesheet><!-- Stylus Studio meta-information - (c) 2004-2005. Progress Software Corporation. All rights reserved.
<metaInformation>
<scenarios ><scenario default="yes" name="A01" userelativepaths="yes" externalpreview="no" url="file://\\vidar\g$\temp\class&#x2D;EN\xml\a.xml" htmlbaseurl="" outputurl="" processortype="internal" useresolver="no" profilemode="0" profiledepth="" profilelength="" urlprofilexml="" commandline="" additionalpath="" additionalclasspath="" postprocessortype="none" postprocesscommandline="" postprocessadditionalpath="" postprocessgeneratedext="" validateoutput="no" validator="internal" customvalidator=""/></scenarios><MapperMetaTag><MapperInfo srcSchemaPathIsRelative="yes" srcSchemaInterpretAsXML="no" destSchemaPath="" destSchemaRoot="" destSchemaPathIsRelative="yes" destSchemaInterpretAsXML="no"/><MapperBlockPosition></MapperBlockPosition><TemplateContext></TemplateContext><MapperFilter side="source"></MapperFilter></MapperMetaTag>
</metaInformation>
-->