var DTDVERSION="ripcis-0-97.dtd";
//var XSLT="ipcentry.xsl";

var xmlObjectClass = getXmlObjectClass(["Msxml2.DOMDocument.4.0","Msxml2.DOMDocument.6.0"]); // 20150915 TA
var fso = new ActiveXObject("Scripting.FileSystemObject");
//var xsltObjectClass = "Msxml2.XSLTemplate.4.0";
var xslDocObjectClass = "Msxml2.FreeThreadedDOMDocument.4.0";

var xmlDoc;
//var xslt = new ActiveXObject(xsltObjectClass);
//var xslDoc = new ActiveXObject(xslDocObjectClass);
//var xslProc;

var inputFile;
var outputFolder;
var htmlTargetFolder;
//var convertXslName;

var lang;
var lang2;
var edition;

var level;
var split;

var edition;

 var sectionFile;
 var classFile;
 var subclassFile;

var bNoteEditions=false;

//try
{
WScript.echo('IPC8 splitting V.0.1');
parseParameters();
log('Create/check output folder:'+outputFolder+"...");
createFolder(outputFolder);
createFolder(outputFolder+"\\xml");
createFolder(outputFolder+"\\doc");

log('Load XML file:'+inputFile+"...");
loadRIPCISFile(inputFile);
repairLines(xmlDoc);
log('XML file loaded.');
log('Separate references...');
separateRefs();
//log('Remove tabs and ln\'s from text nodes...');
//removeTabs();
log('start splitting...');
splitRIPCISFile(outputFolder + "\\xml");
createIndexFile(outputFolder + "\\xml");

log('splitting finished.');

}
//catch(e){
//	log(e.message);
//	log("error: conversion aborted");
//}

function repairLines(oXML) {
	log('Remove lines.');
	var oLines = oXML.selectNodes('//ipcEntry[@kind="l"]');
	for (var i = 0; i < oLines.length; i++) {
		var oLine = oLines[i];
		oLine.parentNode.removeChild(oLine);
	}
	
	log('Collect guide headings.');
	var aGuides = [];
	var oGuides = oXML.selectNodes('//ipcEntry[@kind="g"]');
	for (var i = 0; i < oGuides.length; i++) {
		var oGuide = oGuides[i];
		var sSymbol = oGuide.getAttribute('symbol');
		var sEnd = oGuide.getAttribute('endSymbol');
		aGuides[sSymbol] = 1;
		aGuides['E' +sEnd] = 1;
	}
	
	log('Add lines.');
	var oMains = oXML.selectNodes('//ipcEntry[@kind="m"]');
	var sPrevMainSym = '';
	for (var i = 0; i < oMains.length; i++) {
		var oMain = oMains[i];
		var sSymbol = oMain.getAttribute('symbol');

		if (aGuides[sSymbol] == null && aGuides['E' +sPrevMainSym] != null) {
			//log('Insert line before ' +sSymbol +'.');
			var oLine = oXML.createElement('ipcEntry');
			oLine.setAttribute('kind', 'l');
			// 20150915 TA check main lang
			var sMainLang = oMain.getAttribute('lang');
			if( sMainLang == null )
				sMainLang = lang.toUpperCase();
			oLine.setAttribute('lang', sMainLang);
			oLine.setAttribute('symbol', sSymbol);
			oMain.parentNode.insertBefore(oLine, oMain);
		}
		
		sPrevMainSym = sSymbol;
	}
}

function splitRIPCISFile(  outputFolder )
/*****************************************************************
	`description`
															 2/9/2005 4:16PM
*****************************************************************/
{
	 // walk through nodes and generate output files


	 	sectionFile=null;
	 	classFile=null;
	 	subclassFile=null;


	 	root = xmlDoc.selectSingleNode("/revisionPeriods/revisionPeriod/ipcEdition[@ipcLevel='"+level+"']/"+getLangRoot(lang.toLowerCase())+"/staticIpc");
		if( root==null){
			// 20150915 TA root for XSD 3.1
			root = xmlDoc.selectSingleNode("/IPCScheme[@lang='"+lang.toUpperCase()+"']");
			bNoteEditions = true;
			if( root == null )
				throw new Error("could not select level:"+level+",lang:"+lang);
		}
	 	var section;
	 	var sectionNo;
	 	var oClass;
	 	var classNo;
	 	for(sectionNo=0;sectionNo<root.childNodes.length;sectionNo++){
			section = root.childNodes.item(sectionNo);
			if( split != "section" ){
				createHierarchy(outputFolder,section,"c");
				for(classNo=0;classNo<section.childNodes.length;classNo++){
					oClass = section.childNodes(classNo);
					if( oClass.getAttribute("kind") == "c" ){
						if( split != "class" ){
							createHierarchy(outputFolder,oClass,"u");
							for(subclassNo=0;subclassNo<oClass.childNodes.length;subclassNo++){
								subclass = oClass.childNodes(subclassNo);
								if( subclass.getAttribute("kind") == "u" ){
									splitFile(outputFolder,subclass);
								}
							}
						}else{
							splitFile(outputFolder,oClass);
						}
					}
				}
			}else{
				splitFile(outputFolder,section);
			}
	 	}
}  // convertRIPCISFile

function createIndexFile(outputFolder)
{
	outputFileName = outputFolder + "\\index.xml";
	var outFile;
	var root;
	 	root = xmlDoc.selectSingleNode("/revisionPeriods/revisionPeriod/ipcEdition[@ipcLevel='"+level+"']/"+getLangRoot(lang.toLowerCase())+"/staticIpc");
		if( root==null){
			// 20150915 TA root for XSD 3.1
			root = xmlDoc.selectSingleNode("/IPCScheme[@lang='"+lang.toUpperCase()+"']");
			bNoteEditions = true;
			if(root==null)
				throw new Error("could not select level:"+level+",lang:"+lang);
		}
	outFile = fso.CreateTextFile(outputFileName, true, true);
	outFile.WriteLine("<?xml version=\"1.0\" encoding=\"unicode\"?>");
//	outFile.WriteLine("<!DOCTYPE ipcEntries SYSTEM \"" + DTDVERSION + "\">");
//	outFile.WriteLine("<?xml-stylesheet href=\"" + XSLT + "\" type=\"text/xsl\"?>\n");
	outFile.WriteLine("<ipcEntries displayMode=\"e"+edition +'" level="' +level +'" lang="'+lang+'" noteEditions="'+bNoteEditions+'" splitLevel="' + split +'">');
	 	for(sectionNo=0;sectionNo<root.childNodes.length;sectionNo++){
			section = root.childNodes.item(sectionNo);
			writeHead(outFile,section,true,false);
			outFile.WriteLine("</ipcEntry>");
		}

	outFile.WriteLine("</ipcEntries>");
	outFile.close();

	WScript.echo(outputFileName);
//	convertXml2Html(outputFileName,htmlTargetFolder+"index.htm");
}

function createHierarchy( outputFolder,root, childKind )
{
	var symbol;
	symbol = root.getAttribute("symbol");
	var childNo;

	outputFileName = outputFolder + "\\" + symbol.toLowerCase() + ".xml";

	var outFile;
	outFile = fso.CreateTextFile(outputFileName, true, true);
//	outFile.WriteLine("<?xml version=\"1.0\" encoding=\"iso-8859-1\"?>");
	outFile.WriteLine("<?xml version=\"1.0\" encoding=\"unicode\"?>");
	//outFile.WriteLine("<!DOCTYPE staticIpc SYSTEM \"" + DTDVERSION + "\">");
//	outFile.WriteLine("<!DOCTYPE ipcEntries SYSTEM \"" + DTDVERSION + "\">");
//	outFile.WriteLine("<?xml-stylesheet href=\"" + XSLT + "\" type=\"text/xsl\"?>\n");
	//outFile.WriteLine("<staticIpc lang=\""+lang2+"\" edition=\""+edition+"\" ipcLevel=\""+level+"\">");
	outFile.WriteLine("<ipcEntries displayMode=\"e" +edition +'" level="' +level +'" lang="'+lang+'" noteEditions="'+bNoteEditions+'" splitLevel="' + split +'">');
	var parents=new Array();
	var parent=root.parentNode;
	for(p=0;parent!=null;parent=parent.parentNode){
			parents[p++]=parent;
	}
	for(p--;p>=0;p--){
		if(parents[p].nodeName=="ipcEntry"){
			writeHead(outFile,parents[p],0,false);
			outFile.WriteLine("</ipcEntry>");
			if (parents[p].getAttribute('kind') == 's') {
				// Section note, 20070227; formerly: first (any) note of parents[p] was exported...
				// 20151002 TA Section notes are NOT to be exported in all class files, only in first
			 	// var oNodes = parents[p].selectNodes('ipcEntry[@kind!="c" and (@symbol="' +symbol +'" or @symbol="' +symbol.charAt(0) +'")]');
			 	var oNodes;
			 	oNodes = parents[p].selectNodes('ipcEntry[@kind!="c" and (@symbol="' +symbol +'" or @symbol="' +symbol.charAt(0) +'")]');
			 	for (var i = 0; i < oNodes.length; i++)
					outFile.WriteLine(oNodes[i].xml.replace(/[\r\n\t]/g, ''));
			}
		}
	}

	writeHead(outFile,root,1,false);
	var childNo;
	var child;

	for ( childNo=0;childNo<root.childNodes.length; childNo++) {
		child = root.childNodes.item(childNo);
		var v=child.getAttribute("kind");
		if( v == childKind || v == "n" || v == "t" || v=="i"){
			writeHead(outFile,child,0, false);
			outFile.WriteLine("</ipcEntry>");
			if (v == 'c') {
				//WScript.echo('Append "u" children: ' +child.getAttribute('symbol') +' / ' +lang); //ownerDocument.
				// 20150916 language not to take in consideration, '@lang="' +lang.toUpperCase() ' condition removed
				var oNodes = child.selectNodes('.//ipcEntry[@kind="u" and substring(@symbol, 1, 3)="' +child.getAttribute('symbol') +'"]');
				for (var i = 0; i < oNodes.length; i++) {
					writeHead(outFile, oNodes[i] ,0, true);
					outFile.WriteLine("</ipcEntry>");
				}
			}
		}
	}
	outFile.WriteLine("</ipcEntry>");
	//outFile.WriteLine("</staticIpc>");
	outFile.WriteLine("</ipcEntries>");
	outFile.close();

	WScript.echo(outputFileName);
//	convertXml2Html(outputFileName,htmlTargetFolder+symbol.toLowerCase()+".htm");
}

function writeHead( outFile,root, needSource, bMode_U )
/*****************************************************************
	`description`
															 2/9/2005 9:09PM
*****************************************************************/
{
	outFile.Write("<ipcEntry");
	var attrNo;
	var a;
	for( attrNo=0;attrNo < root.attributes.length;attrNo++){
			a = root.attributes.item(attrNo);
			outFile.Write(" "+a.name+"=\""+a.value+"\"");

	}
	if( needSource ){
		outFile.Write(" source=\""+inputFile+"\"");
	}
	outFile.WriteLine(">");
	var child;
	var t;
	for ( childNo=0;childNo<root.childNodes.length; childNo++) {
		child = root.childNodes.item(childNo);
		if( child.nodeName=="textBody" ){
			if (!bMode_U) {
				t = child.xml;
				//t = t.replace(/\r\n/g,'\n');
				t = t.replace(/[\t\r\n]/g, '');
				outFile.Write(t);
				break;
			} else {
				t = '<textBody><title>';
				var oParts = child.selectNodes('.//titlePart');
				for (var j = 0; j < oParts.length; j++) {
					t += '<titlePart><text>';
					oText = oParts[j].childNodes[0]; // text
					for (var i = 0; i < oText.childNodes.length; i++) {
						var oItem = oText.childNodes[i];
						if (oItem.nodeName == '#text')
							t += oItem.text.charAt(0) +oItem.text.substr(1).toLowerCase();
						else
							t += oItem.xml;
					}
					t += '</text></titlePart>';
				}
				t += '</title></textBody>';
//				t = t.replace(/\r\n/g,'\n');
				t = t.replace(/[\t\r\n]/g, '');
				outFile.Write(t);
			}
		}
	}
}  // writeHead
function splitFile( outputFolder,root )
/*****************************************************************
	`description`
															 2/9/2005 5:13PM
*****************************************************************/
{
	var symbol;
	symbol = root.getAttribute("symbol");

// Zedas
//	log("//ipcEntry[@kind='t' and @symbol='"+root.getAttribute('symbol')+"']");
	var sHeading = '';
	var oPrev=root.previousSibling;
	while(oPrev.getAttribute("symbol") == symbol ){
		sHeading = oPrev.xml.replace(/[\r\n\t]/g, '') + sHeading;
		oPrev = oPrev.previousSibling;
	}
	//var oHeader = xmlDoc.selectNodes("//ipcEntry[(@kind='t' or @kind='n') and @symbol='"+root.getAttribute('symbol')+"' and @lang='" +lang2 +"']");
	//var sHeading = '';
	//if (oHeader != null){
	//
	//	sHeading = oHeader.xml.replace(/[\r\n\t]/g, '');
	//}
// Zedas

	var outputFileName;
	outputFileName = outputFolder + "\\" + symbol.toLowerCase() + ".xml";
	var outFile;
	outFile = fso.CreateTextFile(outputFileName, true, true);
//	outFile.WriteLine("<?xml version=\"1.0\" encoding=\"iso-8859-1\"?>");
	outFile.WriteLine("<?xml version=\"1.0\" encoding=\"unicode\"?>");
//	outFile.WriteLine("<!DOCTYPE ipcEntries SYSTEM \"" + DTDVERSION + "\">");
//	outFile.WriteLine("<?xml-stylesheet href=\"" + XSLT + "\" type=\"text/xsl\"?>\n");
	var s;
	s = xmlDoc.createAttribute("source");
  s.value = inputFile;

  root.attributes.setNamedItem(s);

//	var t = root.xml;
//	t = t.replace(/[\r\t\n]/g, '');
	outFile.WriteLine("<ipcEntries displayMode=\"e"+edition +'" level="' +level +'" lang="'+lang+'" noteEditions="'+bNoteEditions+'" splitLevel="' + split +'">');
	var parents=new Array();
	var parent=root.parentNode;
	for(p=0;parent!=null;parent=parent.parentNode){
			parents[p++]=parent;
	}
	for(p--;p>=0;p--){
		if(parents[p].nodeName=="ipcEntry"){
			writeHead(outFile,parents[p],0, false);
			outFile.WriteLine("</ipcEntry>");
			if (symbol.substr(1) == '01' && parents[p].getAttribute('kind') == 's') {
				// Section note, 20070227; formerly: first (any) note of parents[p] was exported...
			 	var oNote = parents[p].selectSingleNode('ipcEntry[@kind="n" and @symbol="' + symbol.charAt(0) + '"]');
			 	if (oNote != null)
					outFile.WriteLine(oNote.xml.replace(/[\r\n\t]/g, ''));
			}
		}
	}

	outFile.WriteLine(sHeading);

	outFile.Write(root.xml.replace(/[\r\n\t]/g, ''));

	outFile.WriteLine("</ipcEntries>");



	outFile.close();
	WScript.echo(outputFileName);
//	convertXml2Html(outputFileName,htmlTargetFolder+symbol.toLowerCase()+".htm");

}  // splitFile

function createFolder( s )
/*****************************************************************
	`description`
															 2/9/2005 4:49PM
*****************************************************************/
{

	try{
		var myFolder = fso.GetFolder(s);
		return;
	}
	catch(e){}

	try{
		var myFolder=fso.CreateFolder(s);
		return;
	}
	catch(e){
		throw new Error("folder " + s + " could not be created.")
	}

}  // createFolder

function loadRIPCISFile(s)
/*****************************************************************
	`description`
															 2/9/2005 1:29PM
*****************************************************************/
{

	xmlDoc = new ActiveXObject(xmlObjectClass);
	xmlDoc.async = false;
	xmlDoc.resolveExternals = false;
	xmlDoc.validateOnParse = false;
	if( !xmlDoc.load(s) ){
		 var myErr = xmlDoc.parseError;

			throw new Error("could not load XML document\n("+myErr.line+","+myErr.linepos+")"+myErr.reason+"\n"+myErr.srcText);
	}

		if( xmlDoc.childNodes.length==0){
			throw new Error("read XML document is invalid or empty");
		}

		var r;
	 	r = xmlDoc.selectSingleNode("/revisionPeriods/revisionPeriod/ipcEdition[@ipcLevel='" +level +"']");
		if( r==null ){
			r = xmlDoc.selectSingleNode("/IPCScheme[@lang='"+lang.toUpperCase()+"']");
			bNoteEditions = true;
			if( r == null ){
				throw new Error("XML document does not contain ipcEdition" );
			}
		}
		edition = r.getAttribute("edition");
}  // loadRIPCISFile(s)


function parseParameters(  )
/*****************************************************************
	`description`
															 2/5/2004 3:04PM
*****************************************************************/
{
	var parameterError;
	var message;

	WScript.echo(WScript.arguments.length);
	if( WScript.arguments.length < 4 ){
		parameterError = 1;
		message = "\nnot enough parameters\n";
	}else{
		parameterError = 0;
	}

	if( !parameterError ){
		var a;
		var s;


		inputFile = WScript.arguments(0);
		outputFolder = WScript.arguments(1);

		var j;
		var p;
		var k;
		var v;
		message = "\n";
		lang="";
		level="";
		split="";
		for(j=2;j<WScript.arguments.length;j++){
			p = WScript.arguments(j);
			k = p;
			k = k.replace(/^([^=]*)=.*$/g,"$1");
			v = p;
			v = v.replace(/^([^=]*)=(.*)$/g,"$2");
			WScript.echo("["+k + "]["+v+"]")
			if(k=='-lang'){
				lang=v.toLowerCase();
				lang2=v.toUpperCase();
			}else if( k=='-level'){
				v=v.toLowerCase();
				if( v == "core" ){
					level="c";
				}else if( v == "advanced" ){
					level="a";
				}else{
					message = message + "no such level: " + v + "\n";
					parameterError = 1;
				}
			}else if( k=='-split'){
				split=v.toLowerCase();
				if( v!='section' && v!='class' && v !='subclass' ){
					message = message + "no such split: "+v+"\n";
					parameterError = 1;
				}
			}else{
				message = message + "no such parameter:" + k+"\n";
				parameterError=1;
			}

		}
	}
	if( lang =="" ){
			parameterError=1
			message=message+"lang missing"+"\n";
	}
	if( split =="" ){
			parameterError=1
			message=message+"split missing"+"\n";
	}
	if( level =="" ){
			parameterError=1
			message=message+"level missing"+"\n";
	}
	htmlTargetFolder = outputFolder + "\\htm\\" ;
//	convertXslName =  outputFolder + "\\xml\\"+ XSLT;

	if( parameterError ){
		throw( new Error(message+"usage: inputFile outputFolder -lang=[en|fr] -level=[core|advanced] -split=[section|class|subclass]"));
	}
}

function copyFiles( sourceFolder, targetFolder )
/*****************************************************************
	`description`
															2/10/2005 6:24AM
*****************************************************************/
{
	try{
	fso.CopyFile(sourceFolder+"\\*.*", targetFolder)
	}
	catch(e){}
}  // copyFiles
function log( s )
/*****************************************************************
	`description`
															 2/9/2005 1:43PM
*****************************************************************/
{
	var d=new Date();
	d.getTime();
	WScript.echo(d.getYear()+"-"+d.getMonth()+"-"+d.getDate()+" "+d.getHours()+":"+d.getMinutes()+":"+d.getSeconds()+" "+s);

}  // log

function separateRefs() {
	var aoRefs = xmlDoc.selectNodes('//index//references');
	var aStack = new Array();
	var iDepth = 0, oColl = null, bFirst;

	for (var i = 0; i < aoRefs.length; i++) {
		var oRef = aoRefs[i];
		bFirst = true;
		sRoot = '';
/*
		bDebug = (i == 3184) || (i == 6744) || (i == 10308) || (i == 13872);
		if (bDebug) {
			log(i);
			log(oRef.parentNode.xml);
		}*/
		var oNewRef = xmlDoc.createElement('references');
		while (oRef.childNodes.length > 0) {
			var oNode = oRef.childNodes[0];

			switch (oNode.nodeName) {
				case 'sref':
					if (sRoot == '') {
						sRoot = oNode.getAttribute('ref').substr(0, 4);
						iDepth += 11;
					} else if (oNode.getAttribute('ref').substr(0, 4) == sRoot)
						iDepth += 5;
					else
						iDepth += 11;
					break;
				case 'mref':
					iDepth += 21;
					break;
			}
/*
			if (bDebug) {
				log('1: ' +oNode.nodeName +', ' +bFirst +', ' +iDepth +', ' +(oColl != null ? oColl.xml : '-'));
			}
*/
			if (iDepth > (bFirst ? 16 : 32)) {
				if (oColl != null)
					oNewRef.appendChild(oColl);
				iDepth = 0;
				oColl = null;
				bFirst = false;
			}

			switch (oNode.nodeName) {
				case 'sref':
					if (oColl == null)
						oColl = xmlDoc.createElement('refgroup');

					oColl.appendChild(oNode);

					break;
				case 'mref':
					if (oColl == null)
						oColl = xmlDoc.createElement('refgroup');

					oColl.appendChild(oNode);

					break;
				case '#text':
					if (oColl == null)
						oNewRef.appendChild(oNode);
					else
						oColl.appendChild(oNode);

					break;
			}
/*
			if (bDebug) {
				log('2: ' +oNode.nodeName +', ' +bFirst +', ' +iDepth +', ' +(oColl != null ? oColl.xml : '-'));
			}
*/
		}

		if (oColl != null) {
			oNewRef.appendChild(oColl);
			iDepth = 0;
			oColl = null;
		}

		while (oNewRef.childNodes.length > 0) {
			oRef.appendChild(oNewRef.childNodes[0]);
		}
/*
		if (bDebug) {
			log(oRef.parentNode.xml);
		}
*/
	}

	log(String(aoRefs.length) +' references modified');
}

function removeTabs() {
	var aoRefs = xmlDoc.selectNodes('//text');

	for (var i = 0; i < aoRefs.length; i++) {
		var oRef = aoRefs[i];

		while (oRef.childNodes.length > 0) {
			var oNode = oRef.childNodes[0];

			switch (oNode.nodeName) {
				case '#text':
					oNode.text = oNode.text.replace(/\t\n\r/g, '');
					break;
			}
		}
	}

	log(String(aoRefs.length) +' text nodes cleaned');
}


function getLangRoot( ln )
/*****************************************************************
	`description`
															11/5/2005 3:57PM
*****************************************************************/
{

	if( ln == 'en' || ln == 'fr' ){
		return ln;
	}
	return "translation[@lang='" + ln.toUpperCase() + "']";

}  // getLangRoot

// 20150915 TA
function getXmlObjectClass(aOptions)
{
	for(var i in aOptions){
		var sClass= aOptions[i];
		try{
			var oXml = new ActiveXObject(sClass);
			return sClass;
		}
		catch(e){
		}
	}
	throw "No valid XML object class";
}