var xmlObjectClass = getXmlObjectClass(["Msxml2.DOMDocument.4.0","Msxml2.DOMDocument.6.0"]); // 20150915 TA 
var xslObjectClass = getXmlObjectClass(["MSXML2.FreeThreadedDOMDocument.4.0","MSXML2.FreeThreadedDOMDocument.6.0"]); // 20150915
var xsltObjectClass = getXmlObjectClass(["Msxml2.XSLTemplate.4.0","Msxml2.XSLTemplate.6.0"]); // 20150915

	
var aRegexp = new Array();

updateXML();

function updateXML() {
	if( WScript.arguments.length < 1 ){
		parameterError = 1;
		message = "\nnot enough parameters\n";
	}else{
		parameterError = 0;
	}

	var sRoot = WScript.arguments(0);
	var sTempl = WScript.arguments(1);
	
	var sBaseFolder = WScript.arguments(3);
	loadHyphenate(sTempl);

	var sRes = '';
	try {
		var oFSO = new ActiveXObject('Scripting.FileSystemObject');
		var oXML = new ActiveXObject(xmlObjectClass); // 20150915 TA
	    oXML.async = false;
	    oXML.resolveExternals = true; // 20150915 TA set to true
	    oXML.validateOnParse = false;
		var oXSL = new ActiveXObject(xslObjectClass); // 20150915 TA
	    oXSL.async = false;
	    oXSL.resolveExternals = true; // 20150915 TA set true
	    try{
		    oXSL.setProperty("AllowXsltScript", true); // 20150915 TA set true
		    oXSL.setProperty("AllowDocumentFunction", true); // 20150915 TA set true
		}
		catch(e){}
	    oXSL.load('ripcis2wxml.xsl');
		var oXSL2 = new ActiveXObject(xslObjectClass); // 20150915 TA
	    oXSL2.async = false;
	    oXSL2.resolveExternals = true; // 20150915 TA set true
	    try{
		    oXSL2.setProperty("AllowXsltScript", true); // 20150915 TA set true
		    oXSL2.setProperty("AllowDocumentFunction", true); // 20150915 TA set true
		}
		catch(e){}
	    oXSL2.load('simple-ripcis2wxml.xsl');

		WScript.echo(sRoot +'\\xml');
		
		
		var oFolder = oFSO.GetFolder(sRoot +'\\xml');
		var oEnum = new Enumerator(oFolder.Files);
		var oFile, sName;
		for (; !oEnum.atEnd(); oEnum.moveNext()) {
			oFile = oEnum.item();
			sName = oFile.name;
			
			try {
			    oXML.load(String(oFile.path));
				
				var oXSLT = new ActiveXObject(xsltObjectClass);
				if( /^[a-zA-Z]\.xml$/.test(sName) ){
					oXSLT.stylesheet = oXSL2;
				}else{
					oXSLT.stylesheet = oXSL;
				}
				var oXSLProc = oXSLT.createProcessor();
				oXSLProc.addParameter('dotfile',sBaseFolder + "\\ipcpub.dot");
				
				oXSLProc.input = oXML;
				oXSLProc.transform();
				sData = oXSLProc.output;

				oXML.loadXML(doHyphenate(sData));

				oXML.save(sRoot +'\\doc\\' +sName);

				WScript.echo(sName +' - Ok');
			} catch (e) {
				WScript.echo(sName +' - Error: ' +e.message);
			}
		}
	} catch(e) {
		WScript.echo('Error: ' +e.message);
	}
}



function loadHyphenate(sTempl)
{
	WScript.echo("Hyphenation file: [" + sTempl + "\\hyphenate.txt"+"]");
var oFSO = new ActiveXObject("Scripting.FileSystemObject");
var oStream = oFSO.OpenTextFile(sTempl + "\\hyphenate.txt");
var l;
var r;
while ( !oStream.AtEndOfStream ) {
	l = oStream.ReadLine();
	if ( l!='' ) {
		l = "([\\w])(" + l + ")([^\\w])";
		r= new RegExp(l,"g");
		aRegexp.push(r);
	}
}
oStream.close();
}

function doHyphenate( sXml )
{
	var i;
	for ( i in aRegexp ) {
		r=aRegexp[i]
		sXml = sXml.replace(r,"$1<w:softHyphen/>$2$3");
	}
	return sXml;
}


// 20150915 TA
function getXmlObjectClass(aOptions)
{
	for(var i in aOptions){
		var sClass= aOptions[i];
		try{
			var oXml = new ActiveXObject(sClass);
			return sClass;
		}
		catch(e){
		}
	}
	throw "No valid XML object class";
}