var msg = function(title, msg, icon){
    Ext.Msg.show({
        title: title, 
        msg: msg,
        minWidth: 200,
        modal: true,
        icon: icon,
        buttons: Ext.Msg.OK
    });
};

var currentfile = null;
    
function getFiles() {
    Ext.Ajax.request({
        url: applUrl,
        method: "GET",
        params: {
            action: 'getfiles'
        },
        success: function(response, opts){
            var resp = Ext.util.JSON.decode(response.responseText);
            filesStore.loadData(resp.data);
            filesGrid.getSelectionModel().selectLastRow();
        }
    });
}
        
function exportFile() {
    Ext.Ajax.request({
        url: applUrl,
        method: "GET",
        params: {
            action: 'export',
            file: filesGrid.getSelectionModel().getSelections()[0].data.file
        },
        success: function(response, opts){
            var resp = Ext.util.JSON.decode(response.responseText);
            msg('Success',resp.file.concat(' successfully exported to <br/>',resp.exportdir),Ext.Msg.INFO);
        }
    });
}

var fp = new Ext.FormPanel({
    fileUpload: true,
    frame: true,
    labelWidth: 50,
    defaults: {
        anchor: '95%',
        allowBlank: false,
        msgTarget: 'side'
    },
    items: [{
        xtype: 'fileuploadfield',
        id: 'form-file',
        emptyText: 'Select a File',
        fieldLabel: 'File',
        name: 'filepath',
        buttonText: '',
        buttonCfg: {
            iconCls: 'upload-icon'
        }
    }]
});

var openWin;
function importFile(){
    if(!openWin){
        openWin = new Ext.Window({
            width:400,
            height:180,
            closeAction:'hide',
            closable: false,
            bodyStyle:'padding:5px;',
            items: [
                fp,
                {
                    xtype:'label',
                    html:'<br/>Please select a file named <b>ipcr_elayer_definitions_<i>YYYYMMDD</i>.xml</b><br/><br/>For example: ipcr_elayer_definitions_20091231.xml'
                }
            ],
            buttons: [{
                text:'Submit',
                handler: function(){
                    if(fp.getForm().isValid()){
    	                fp.getForm().submit({
    	                    url: applUrl.concat('?action=import'),
    	                    waitMsg: 'Uploading your file...',
    	                    success: function(fp, o){
                                filesStore.loadData(o.result.files);
                                filesGrid.getSelectionModel().selectLastRow();
                                openWin.hide(openWin);
    	                    },
                            failure: function(fp, o) {msg('ERROR',o.result.msg,Ext.Msg.ERROR)}
    	                });
                    }
                }
            },{
                text: 'Close',
                handler: function(){
                    openWin.hide(this);
                }
            }]
        })
    }
    openWin.show(this);
}

var filesStore = new Ext.data.ArrayStore({
    idIndex: 0,
    fields: [
       {name: 'file'},
       {name: 'torevise'},
       {name: 'totranslate'},
       {name: 'tocheck'},
       {name: 'done'}
    ]
});

function stateRender(value, metaData, record, rowIndex, colIndex, store) {
    if (colIndex == 1) {
        return '<span style="color:red;font-weight: bold;">' + value + '</span>';
    } else if (colIndex == 2 || colIndex == 3){
        return '<span style="color:green;font-weight: bold;">' + value + '</span>';
    } else if (colIndex == 4 ){
        return '<span style="color:black;font-weight: bold;">' + value + '</span>';
    }
    return val;
}

var filesGrid = new Ext.grid.GridPanel({
    id: 'filesGrid',
    store: filesStore,
    sm: new Ext.grid.RowSelectionModel({singleSelect:true}),
    enableColumnMove: false,
    enableColumnResize: false,
    enableColumnHide: false,
    enableHdMenu: false,
    columns: [
        {id:'file',header: "File", width: 150, sortable: false, dataIndex: 'file'},
        {id:'totranslate',header: "To translate", width: 100, sortable: false, dataIndex: 'totranslate', renderer: stateRender},
        {id:'tocheck',header: "To check", width: 100, sortable: false, dataIndex: 'tocheck', renderer: stateRender},
        {id:'torevise',header: "To revise", width: 100, sortable: false, dataIndex: 'torevise', renderer: stateRender},
        {id:'done',header: "Done", width: 100, sortable: false, dataIndex: 'done', renderer: stateRender}
    ]
});

Ext.onReady(function(){
    var viewport = new Ext.Viewport({
        layout: 'border',
        items: [
            new Ext.Toolbar({
                region:'north',
                height:25,
                margins:'2 2 0 2',
                items:[{
                    },{
                        text: 'Import (split file)',
                        handler: function(){importFile();}
                    },{
                        text: 'Export (unsplit files)',
                        id: 'export',
                        handler: function(){exportFile();}
                    },{
                        text: 'Refresh list',
                        id: 'refresh',
                        handler: function(){getFiles();}
                    }
                ]
            }),{
                region:'center',
                layout:'fit',
                items: filesGrid
            }
        ]
    });
    getFiles();
});