Ext.onReady(function(){
    Ext.QuickTips.init();
    
    var selected = null;
    var currentfile = null;
    
    function getFiles() {
        Ext.Ajax.request({
            url: applUrl,
            method: "GET",
            params: {
                action: 'getfilelist'
            },
            success: function(response, opts){
                openMenu.removeAll();
                var resp = Ext.util.JSON.decode(response.responseText);
                for (e=0; e<resp.data.length; e++) {
                    openMenu.add(new Ext.menu.Item({
                        text: resp.data[e],
                        handler: function(){
                            loadSymbols(this.text);
                        }
                    }));
                }
                openMenu.doLayout();
            }
        });
    }
    getFiles();
    
    var openMenu = new Ext.menu.Menu();
    
    function loadSymbols(filename) {
        if (filename != currentfile) {
            Ext.Ajax.request({
                url: applUrl,
                method: "GET",
                params: {
                    action: 'getfile',
                    file: filename
                },
                success: function(response, opts){
                    var resp = Ext.util.JSON.decode(response.responseText);
                    symbolsStore.loadData(resp.data);
                    currentfile = filename;
                    selected = null;
                    var symbols = viewport.findById('symbols');
                    symbols.setTitle(currentfile);
                    symbols.expand();
                    viewport.findById('viewer').collapse();
                    viewport.findById('edit').disable();
                }
            });
        }
    }
    
    var msg = function(title, msg, icon){
        Ext.Msg.show({
            title: title, 
            msg: msg,
            minWidth: 200,
            modal: true,
            icon: icon,
            buttons: Ext.Msg.OK
        });
    };
        
    function toggleButton(button,state) {
        var exit = button.ownerCt.getComponent('exit');
        if (state) {
            exit.setText("Save");
        }else{
            exit.setText("Exit");
        }
    }
    
    var states = ['R','T','I','E'];
    var editorWin = new Ext.Window({
        id:'editor',
        title: 'Editor',
        modal: true,
        layout: 'fit',
        width:600,
        height:600,
        closable: false,
        closeAction:'hide',
        bodyStyle:'padding:5px;',
        items: new Ext.FormPanel({
            url:applUrl,
            id:'editorForm',
            frame:true,
            autoScroll:true,
            defaults: {
                hideLabel: true,
                width: 540,
                grow: true,
                growMin: 1,
                preventScrollbars: true
            },
            defaultType: 'textarea'
        }),
        listeners: {
            beforeshow: function() {
                for (b in this.buttons) {
                    if (this.buttons[b].enableToggle) {
                        this.buttons[b].toggle(false);
                    }
                }
            }
        },
        buttons: [{
            text:'To translate',
            id: 'T',
            enableToggle: true,
            toggleGroup: 'save',
            toggleHandler: function(button,state){toggleButton(button,state);}
        },{
            text:'To check',
            id: 'I',
            enableToggle: true,
            toggleGroup: 'save',
            toggleHandler: function(button,state){toggleButton(button,state);}
        },{
            text:'To revise',
            //tooltip: 'coucou',
            id: 'R',
            enableToggle: true,
            toggleGroup: 'save',
            toggleHandler: function(button,state){toggleButton(button,state);}
        },{
            text:'No action',
            id: 'E',
            enableToggle: true,
            toggleGroup: 'save',
            toggleHandler: function(button,state){toggleButton(button,state);}
        },{
            text: 'Exit',
            id: 'exit',
            handler: function(b,e){
                var state = "exit";
                for (s=0; s<states.length; s++) {
                    if (b.ownerCt.getComponent(states[s]).pressed) {
                        state = states[s];
                        break;
                    }
                }
                if (state == "exit") {
                    if (editorWin.findById('editorForm').getForm().isDirty()) {
                        Ext.Msg.confirm('Exit','There are several changes not yet saved.<br/>Do you really want to exit anyway?',function(btn, text){
                            if (btn == 'yes') {
                                editorWin.hide(editorWin);
                            }
                        });
                    } else {
                        editorWin.hide(editorWin);
                    }
                } else {
                    saveEntry(states[s]);
                    editorWin.hide(editorWin);
                }
            }
        }]
    });
    
    var symbolsStore = new Ext.data.ArrayStore({
        idIndex: 2,
        fields: [
           {name: 'state'},
           {name: 'symbol'},
           {name: 'symbolcode'},
           {name: 'dirname'}
        ]
    });
    
    function renderEntry(symbol) {
        if (!symbol) 
            var symbol = symbolsGrid.getSelectionModel().getSelections()[0].data.symbolcode;
            
        var viewerUpdater = viewport.findById('viewer').getUpdater();
        viewerUpdater.update({
            url: applUrl,
            method: "GET",
            params: {
                action: 'render',
                file: currentfile,
                symbol: symbol
            },
            callback: function(){viewport.findById('viewer').expand();}
        });
    }
    
    function loadEntry() {
        var selection = symbolsGrid.getSelectionModel().getSelections()[0].data;

        Ext.Ajax.request({
            url: applUrl,
            method: "GET",
            params: {
                file: currentfile,
                symbol: selection.symbolcode
            },
            success: function(response, opts){
                var editorForm = editorWin.findById('editorForm');
                editorForm.removeAll();
                var resp = Ext.util.JSON.decode(response.responseText);
                for (e in resp.data) {
                    if (resp.data[e][0] == 'label') {
                        editorForm.add(new Ext.form.Label({
                            text: resp.data[e][1],
                            style: "font-weight:bold; font-size:12pt; font-family: Arial, Helvetica, sans-serif;"
                        }));
                        
                    } else if (resp.data[e][0] == 'ref') {
                        editorForm.add(new Ext.form.Label({
                            text: resp.data[e][1],
                            style: "font-weight:bold; font-family: Arial, Helvetica, sans-serif;"
                        }));
                        
                    } else if (resp.data[e][0] == 'space') {
                        editorForm.add(new Ext.Spacer({
                            height: 20,
                            style: 'border-bottom: 1px solid;'
                        }));
                        
                    } else if (resp.data[e][0]) {
                        editorForm.add(new Ext.form.TextArea({
                            name: resp.data[e][1].concat(';',resp.data[e][0]),
                            value: resp.data[e][2]
                        }));
                    }
                }
                editorForm.doLayout();
                editorWin.setTitle(selection.symbol);
                editorWin.show(editorWin);
            }
        });
    }
    
    function saveEntry(state) {
        var symbol = symbolsGrid.getSelectionModel().getSelections()[0].data.symbolcode;
        editorWin.findById('editorForm').getForm().submit({
            params: {
                //WARNING: if you add a new paramater do not forget to add it in the "if path not in" test in defedit.py
                action: 'save',
                file: currentfile,
                symbol: symbol,
                state: state
            },
            success: function() {
                renderEntry(symbol);
                var rec = symbolsStore.getById(symbol);
                rec.data['state'] = state;
                rec.commit();
            }
        });
    }
    
    function selectAndRender(grid, rowIndex) {
        var record = grid.getStore().getAt(rowIndex);  // Get the Record
        //var fieldName = grid.getColumnModel().getDataIndex(columnIndex); // Get field name
        var symbol = record.get('symbolcode');
        
        if (selected != symbol) {
            renderEntry(symbol);
            viewport.findById('edit').enable();
            selected = symbol;
        }
    }
    
	var filters = new Ext.ux.grid.GridFilters({
        local:true,
        filters:[
    		{type: 'string', dataIndex: 'state'},
    		{type: 'string', dataIndex: 'symbol'}
    	]
    });
    
    function stateRender(value, metaData, record, rowIndex, colIndex, store) {
        if (colIndex == 3) {
            value = '';
            if (record.data.state != 'T') {
                value = '<a target="_blank" href="/ipcdata/' + record.data.dirname + '/transformations/ipca6transdef/translation/' + record.data.symbolcode + '.xml">&nbsp;X&nbsp;</a>';
            }
        } else if (colIndex == 1) {
            val = record.data.state;
        } else {
            val = value;
        }
        if (val == 'E'){
            return '<span class="state3">' + value + '</span>';
        }else if(val == 'T'){
            return '<span class="state1">' + value + '</span>';
        }else if(val == 'I' || val == 'R'){
            return '<span class="state2">' + value + '</span>';
        }
        return val;
    }
    
    var symbolsGrid = new Ext.grid.GridPanel({
        id: 'symbolsgrid',
        store: symbolsStore,
        sm: new Ext.grid.RowSelectionModel({singleSelect:true}),
        plugins: filters,
        enableColumnMove: false,
        enableColumnResize: false,
        enableColumnHide: false,
        columns: [
            {id:'state',header: "Action", width: 40, sortable: false, dataIndex: 'state', renderer: stateRender},
            {id:'symbol',header: "Symbol", width: 110, sortable: false, dataIndex: 'symbol', renderer: stateRender},
            {hidden: true, dataIndex: 'symbolcode'},
            {id:'xml',header: "XML", width: 40, sortable: false, dataIndex: 'dirname', renderer: stateRender}
        ],
        listeners: {
            cellclick: function(grid, rowIndex, columnIndex, e){
                selectAndRender(grid, rowIndex);
            },
            celldblclick: function(grid, rowIndex, columnIndex, e){
                selectAndRender(grid, rowIndex);
                loadEntry();
            }
        }
    });
    
    var viewport = new Ext.Viewport({
        layout:'border',
        items:[
            new Ext.Toolbar({
                region:'north',
                height:25,
                margins:'2 2 0 2',
                items:[{
                        text: 'Open',
                        menu: openMenu
                    },{
                        xtype: 'menuseparator'
                    },{
                        text: 'Edit',
                        id: 'edit',
                        disabled: true,
                        handler: function(){loadEntry();}
                    }
                ]
            }),{
                region:'west',
                id:'symbols',
                title:'Symbols',
                split:true,
                width: 212,
                minSize: 172,
                maxSize: 172,
                collapsible: true,
                margins:'2 0 2 2',
                layout:'fit',
                items: symbolsGrid
            },{
                region:'center',
                id:'viewer',
                split:true,
                collapsed: true,
                height: 200,
                minSize: 200,
                maxSize: 400,
                title: 'Preview',
                margins:'2 2 2 0',
                autoScroll:true
            }
         ]
    });
});